% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program fittingCSF.m
function [Gmax, Fmax, beta, delta, r2] = fittingCSF(CSF)
data = CSF;   % CSF is the measured contrast sensitivity 
              % function. First row: spatial frequency;
              % Second row: sensitivity.
guess = [200 1.0 8 0.5];    % Gmax, Fmax, beta, delta
options = optimset('fminsearch');
[guess, L] = fminsearch('CSFcostfunc', guess, options, ...
       data);
meanS = mean(log10(CSF(2, :)));
r2 = 1 - L/sum((log10(data(2, :)) - meanS).^2);

Gmax = guess(1);
Fmax = guess(2);
beta = guess(3);
delta = guess(4);


